/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.util.RawVoxelShape;
import com.voxelutopia.ultramarine.world.block.ShiftableBlock;
import com.voxelutopia.ultramarine.world.block.ShiftedTileType;
import com.voxelutopia.ultramarine.world.block.state.ModBlockStateProperties;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;

public class RoofTiles
extends ShiftableBlock {
    public static final BlockBehaviour.Properties PROPERTIES = BlockBehaviour.Properties.m_284310_().m_60999_().m_60913_(1.5f, 4.0f).m_60918_(SoundType.f_154679_);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final IntegerProperty SNOW_LAYERS = ModBlockStateProperties.SNOW_LAYERS;
    public static final EnumProperty<SnowSide> SNOW_SIDE = ModBlockStateProperties.SNOW_SIDE;
    private static final VoxelShape BOTTOM_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape BOTTOM_AABB_SHIFTED = Block.m_49796_((double)0.0, (double)-8.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0);
    private static final RawVoxelShape NORTH_UPPER_RAW = new RawVoxelShape(0.0, 8.0, 0.0, 16.0, 16.0, 8.0);
    private static final VoxelShape NORTH_SHAPE = Shapes.m_83110_((VoxelShape)BOTTOM_AABB, (VoxelShape)NORTH_UPPER_RAW.copy().toVoxelShape());
    private static final VoxelShape WEST_SHAPE = Shapes.m_83110_((VoxelShape)BOTTOM_AABB, (VoxelShape)NORTH_UPPER_RAW.copy().rotateY(90.0f).toVoxelShape());
    private static final VoxelShape SOUTH_SHAPE = Shapes.m_83110_((VoxelShape)BOTTOM_AABB, (VoxelShape)NORTH_UPPER_RAW.copy().rotateY(180.0f).toVoxelShape());
    private static final VoxelShape EAST_SHAPE = Shapes.m_83110_((VoxelShape)BOTTOM_AABB, (VoxelShape)NORTH_UPPER_RAW.copy().rotateY(270.0f).toVoxelShape());
    private static final VoxelShape EAST_SHAPE_SHIFTED = Shapes.m_83110_((VoxelShape)BOTTOM_AABB_SHIFTED, (VoxelShape)Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0));
    private static final VoxelShape NORTH_SHAPE_SHIFTED = Shapes.m_83110_((VoxelShape)BOTTOM_AABB_SHIFTED, (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0));
    private static final VoxelShape SOUTH_SHAPE_SHIFTED = Shapes.m_83110_((VoxelShape)BOTTOM_AABB_SHIFTED, (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0));
    private static final VoxelShape WEST_SHAPE_SHIFTED = Shapes.m_83110_((VoxelShape)BOTTOM_AABB_SHIFTED, (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0));
    private final DyeColor color;
    private final RoofTileType type;

    public RoofTiles(DyeColor color, RoofTileType type) {
        super(PROPERTIES);
        this.color = color;
        this.type = type;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SHIFTED, (Comparable)Boolean.FALSE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_((Property)SNOW_LAYERS, (Comparable)Integer.valueOf(0))).m_61124_(SNOW_SIDE, (Comparable)((Object)SnowSide.BOTH)));
    }

    public void m_141997_(BlockState pState, Level pLevel, BlockPos pPos, Biome.Precipitation pPrecipitation) {
        if (pPrecipitation == Biome.Precipitation.SNOW) {
            this.tryPushSnow(pState, pLevel, pPos);
        }
    }

    private void tryPushSnow(BlockState pState, Level pLevel, BlockPos pPos) {
        RandomSource random = pLevel.m_213780_();
        SlopeAngle forwardAngle = this.checkForwardSlopeAngle(pLevel, pState, pPos);
        if (forwardAngle == SlopeAngle.HIGHER) {
            this.handleSnow(pState, pLevel, pPos);
            return;
        }
        BlockState blockForward = pLevel.m_8055_(pPos.m_121945_(((Direction)pState.m_61143_((Property)FACING)).m_122424_()));
        BlockState blockForwardBelow = pLevel.m_8055_(pPos.m_121945_(((Direction)pState.m_61143_((Property)FACING)).m_122424_()).m_7495_());
        if (forwardAngle == SlopeAngle.LEVEL && random.m_188501_() < 0.5f && blockForward.m_60734_() instanceof RoofTiles && (Integer)blockForward.m_61143_((Property)SNOW_LAYERS) == 15 && random.m_188501_() > 0.9f) {
            this.tryPushSnow(blockForward, pLevel, pPos.m_121945_(((Direction)pState.m_61143_((Property)FACING)).m_122424_()));
            return;
        }
        if (forwardAngle == SlopeAngle.LOWER && random.m_188501_() < 0.8f) {
            if (blockForward.m_60734_() instanceof RoofTiles) {
                if ((Integer)blockForward.m_61143_((Property)SNOW_LAYERS) == 15 && random.m_188501_() > 0.9f) {
                    this.tryPushSnow(blockForward, pLevel, pPos.m_121945_(((Direction)pState.m_61143_((Property)FACING)).m_122424_()));
                    return;
                }
            } else if (blockForwardBelow.m_60734_() instanceof RoofTiles && (Integer)blockForwardBelow.m_61143_((Property)SNOW_LAYERS) == 15 && random.m_188501_() > 0.9f) {
                this.tryPushSnow(blockForwardBelow, pLevel, pPos.m_121945_(((Direction)pState.m_61143_((Property)FACING)).m_122424_()));
                return;
            }
        }
        this.handleSnow(pState, pLevel, pPos);
    }

    private void handleSnow(BlockState pState, Level pLevel, BlockPos pPos) {
        if (!pLevel.m_5776_()) {
            int snow = (Integer)pState.m_61143_((Property)SNOW_LAYERS);
            BlockState newState = (BlockState)pState.m_61124_((Property)SNOW_LAYERS, (Comparable)Integer.valueOf(Math.min(15, ++snow)));
            pLevel.m_46597_(pPos, newState);
            this.updateSideSnow(newState, pLevel, pPos);
        }
    }

    private void removeSnow(BlockState pState, Level pLevel, BlockPos pPos) {
        if (!pLevel.m_5776_()) {
            int snow = (Integer)pState.m_61143_((Property)SNOW_LAYERS);
            BlockState newState = (BlockState)pState.m_61124_((Property)SNOW_LAYERS, (Comparable)Integer.valueOf(Math.max(0, --snow)));
            pLevel.m_46597_(pPos, newState);
            this.updateSideSnow(newState, pLevel, pPos);
        }
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack item = pPlayer.m_21120_(pHand);
        if (item.m_150930_(Items.f_42452_)) {
            this.handleSnow(pState, pLevel, pPos);
            if (!pPlayer.m_7500_()) {
                item.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        if (item.m_41720_() instanceof ShovelItem) {
            this.removeSnow(pState, pLevel, pPos);
            if (!pPlayer.m_7500_()) {
                item.m_41622_(1, (LivingEntity)pPlayer, p -> p.m_21190_(pHand));
            }
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        this.updateSideSnow(pState, pLevel, pPos);
        super.m_6861_(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        this.updateSideSnow(pState, pLevel, pPos);
        this.updateNeighborSideSnow(pState, pLevel, pPos);
        super.m_6807_(pState, pLevel, pPos, pOldState, pIsMoving);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        this.updateNeighborSideSnow(pState, pLevel, pPos);
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    private void updateNeighborSideSnow(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockPos[] posToUpdate;
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        for (BlockPos pos : posToUpdate = this.getSideUpdatePosArray(pPos, direction)) {
            Block block = pLevel.m_8055_(pos).m_60734_();
            if (!(block instanceof RoofTiles)) continue;
            this.updateSideSnow(pLevel.m_8055_(pos), pLevel, pos);
        }
    }

    private BlockPos[] getSideUpdatePosArray(BlockPos pPos, Direction direction) {
        return new BlockPos[]{pPos.m_121945_(direction.m_122427_()), pPos.m_121945_(direction.m_122428_()), pPos.m_121945_(direction.m_122427_()).m_7494_(), pPos.m_121945_(direction.m_122428_()).m_7494_(), pPos.m_121945_(direction.m_122427_()).m_7495_(), pPos.m_121945_(direction.m_122428_()).m_7495_()};
    }

    private void updateSideSnow(BlockState pState, Level pLevel, BlockPos pPos) {
        SnowSide currentSnowSide = (SnowSide)((Object)pState.m_61143_(SNOW_SIDE));
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        BlockPos blockPosLeft = pPos.m_121945_(direction.m_122428_());
        BlockPos blockPosRight = pPos.m_121945_(direction.m_122427_());
        SlopeAngle slopeLeft = this.checkSideSlopeAngle(pLevel, pState, pPos, pLevel.m_8055_(blockPosLeft), blockPosLeft);
        SlopeAngle slopeRight = this.checkSideSlopeAngle(pLevel, pState, pPos, pLevel.m_8055_(blockPosRight), blockPosRight);
        currentSnowSide = slopeLeft == SlopeAngle.LOWER ? SnowSide.add(currentSnowSide, SnowSide.LEFT) : SnowSide.remove(currentSnowSide, SnowSide.LEFT);
        currentSnowSide = slopeRight == SlopeAngle.LOWER ? SnowSide.add(currentSnowSide, SnowSide.RIGHT) : SnowSide.remove(currentSnowSide, SnowSide.RIGHT);
        BlockState newState = (BlockState)pState.m_61124_(SNOW_SIDE, (Comparable)((Object)currentSnowSide));
        pLevel.m_46597_(pPos, newState);
    }

    private SlopeAngle checkSideSlopeAngle(Level level, BlockState self, BlockPos selfPos, BlockState other, BlockPos otherPos) {
        Boolean selfShifted = (Boolean)self.m_61143_((Property)SHIFTED);
        RoofTileType type = ((RoofTiles)self.m_60734_()).getType();
        if (type != RoofTileType.STAIRS) {
            if (selfShifted.booleanValue()) {
                Block blockAbove = level.m_8055_(otherPos.m_7494_()).m_60734_();
                if (blockAbove instanceof RoofTiles) {
                    return SlopeAngle.HIGHER;
                }
                Block blockLevel = other.m_60734_();
                if (blockLevel instanceof RoofTiles) {
                    RoofTiles tileLevel = (RoofTiles)blockLevel;
                    if (!((Boolean)other.m_61143_((Property)SHIFTED)).booleanValue()) {
                        return SlopeAngle.HIGHER;
                    }
                    return tileLevel.getType() == RoofTileType.STAIRS ? SlopeAngle.HIGHER : SlopeAngle.LEVEL;
                }
                if (!other.m_60795_()) {
                    return SlopeAngle.LEVEL;
                }
            } else {
                BlockState blockAbove = level.m_8055_(otherPos.m_7494_());
                if (blockAbove.m_60734_() instanceof RoofTiles && ((Boolean)blockAbove.m_61143_((Property)SHIFTED)).booleanValue()) {
                    return SlopeAngle.HIGHER;
                }
                Block blockLevel = other.m_60734_();
                if (blockLevel instanceof RoofTiles) {
                    RoofTiles tileLevel = (RoofTiles)blockLevel;
                    if (((Boolean)other.m_61143_((Property)SHIFTED)).booleanValue()) {
                        return SlopeAngle.LOWER;
                    }
                    return tileLevel.getType() == RoofTileType.STAIRS ? SlopeAngle.HIGHER : SlopeAngle.LEVEL;
                }
                if (!other.m_60795_()) {
                    return SlopeAngle.HIGHER;
                }
            }
            return SlopeAngle.LOWER;
        }
        if (selfShifted.booleanValue()) {
            BlockState blockAbove = level.m_8055_(otherPos.m_7494_());
            if (!blockAbove.m_60795_()) {
                return SlopeAngle.HIGHER;
            }
            Block blockLevel = other.m_60734_();
            if (blockLevel instanceof RoofTiles) {
                RoofTiles tileLevel = (RoofTiles)blockLevel;
                if (tileLevel.getType() != RoofTileType.STAIRS) {
                    return SlopeAngle.LOWER;
                }
                return (Boolean)other.m_61143_((Property)SHIFTED) != false ? SlopeAngle.LOWER : SlopeAngle.LEVEL;
            }
            if (!other.m_60795_()) {
                return SlopeAngle.LEVEL;
            }
            return SlopeAngle.LOWER;
        }
        Block blockLevel = other.m_60734_();
        if (blockLevel instanceof RoofTiles) {
            RoofTiles tileLevel = (RoofTiles)blockLevel;
            if (!((Boolean)other.m_61143_((Property)SHIFTED)).booleanValue()) {
                return SlopeAngle.HIGHER;
            }
            return tileLevel.getType() == RoofTileType.STAIRS ? SlopeAngle.LEVEL : SlopeAngle.LOWER;
        }
        if (!other.m_60795_()) {
            return SlopeAngle.HIGHER;
        }
        return SlopeAngle.LEVEL;
    }

    private SlopeAngle checkForwardSlopeAngle(Level level, BlockState self, BlockPos selfPos) {
        Boolean selfShifted = (Boolean)self.m_61143_((Property)SHIFTED);
        Direction direction = (Direction)self.m_61143_((Property)FACING);
        RoofTileType type = ((RoofTiles)self.m_60734_()).getType();
        BlockState blockForward = level.m_8055_(selfPos.m_121945_(direction.m_122424_()));
        if (type != RoofTileType.STAIRS) {
            if (selfShifted.booleanValue()) {
                Block block = blockForward.m_60734_();
                if (block instanceof RoofTiles) {
                    RoofTiles tileForward = (RoofTiles)block;
                    if (!((Boolean)blockForward.m_61143_((Property)SHIFTED)).booleanValue()) {
                        return SlopeAngle.HIGHER;
                    }
                    return tileForward.getType() == RoofTileType.STAIRS ? SlopeAngle.HIGHER : SlopeAngle.LEVEL;
                }
                BlockState blockForwardBelow = level.m_8055_(selfPos.m_121945_(direction.m_122424_()).m_7494_());
                if (blockForwardBelow.m_60734_() instanceof RoofTiles && !((Boolean)blockForwardBelow.m_61143_((Property)SHIFTED)).booleanValue()) {
                    return SlopeAngle.LOWER;
                }
            } else {
                BlockState blockForwardAbove = level.m_8055_(selfPos.m_121945_(direction.m_122424_()).m_7494_());
                if (blockForwardAbove.m_60734_() instanceof RoofTiles && ((Boolean)blockForwardAbove.m_61143_((Property)SHIFTED)).booleanValue()) {
                    return SlopeAngle.HIGHER;
                }
                Block block = blockForward.m_60734_();
                if (block instanceof RoofTiles) {
                    RoofTiles tileForward2 = (RoofTiles)block;
                    if (tileForward2.getType() == RoofTileType.STAIRS) {
                        return (Boolean)blockForward.m_61143_((Property)SHIFTED) != false ? SlopeAngle.LOWER : SlopeAngle.HIGHER;
                    }
                    return (Boolean)blockForward.m_61143_((Property)SHIFTED) != false ? SlopeAngle.LOWER : SlopeAngle.LEVEL;
                }
            }
        } else if (selfShifted.booleanValue()) {
            RoofTiles tileForward;
            Block tileForward2 = blockForward.m_60734_();
            if (tileForward2 instanceof RoofTiles && (tileForward = (RoofTiles)tileForward2).getType() != RoofTileType.STAIRS) {
                return SlopeAngle.LOWER;
            }
            if (!blockForward.m_60795_()) {
                return SlopeAngle.HIGHER;
            }
            BlockState blockForwardBelow = level.m_8055_(selfPos.m_121945_(direction.m_122424_()).m_7494_());
            Block block = blockForwardBelow.m_60734_();
            if (block instanceof RoofTiles) {
                RoofTiles tilesForwardBelow = (RoofTiles)block;
                if (((Boolean)blockForwardBelow.m_61143_((Property)SHIFTED)).booleanValue()) {
                    return tilesForwardBelow.getType() == RoofTileType.STAIRS ? SlopeAngle.LOWER : SlopeAngle.HIGHER;
                }
                return SlopeAngle.LOWER;
            }
        } else {
            BlockState blockForwardAbove = level.m_8055_(selfPos.m_121945_(direction.m_122424_()).m_7494_());
            if (blockForwardAbove.m_60734_() instanceof RoofTiles && ((Boolean)blockForwardAbove.m_61143_((Property)SHIFTED)).booleanValue()) {
                return SlopeAngle.HIGHER;
            }
            Block block = blockForward.m_60734_();
            if (block instanceof RoofTiles) {
                RoofTiles tileForward = (RoofTiles)block;
                if (((Boolean)blockForward.m_61143_((Property)SHIFTED)).booleanValue()) {
                    return tileForward.getType() == RoofTileType.STAIRS ? SlopeAngle.HIGHER : SlopeAngle.LOWER;
                }
                return SlopeAngle.LOWER;
            }
        }
        return SlopeAngle.HIGHER;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public RoofTileType getType() {
        return this.type;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{FACING});
        pBuilder.m_61104_(new Property[]{SNOW_LAYERS});
        pBuilder.m_61104_(new Property[]{SNOW_SIDE});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)super.m_5573_(pContext).m_61124_((Property)FACING, (Comparable)pContext.m_8125_());
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Boolean shifted = (Boolean)pState.m_61143_((Property)SHIFTED);
        if (this.type != RoofTileType.STAIRS) {
            return shifted != false ? Block.m_49796_((double)0.0, (double)-8.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0) : Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
        }
        return switch ((Direction)pState.m_61143_((Property)FACING)) {
            case Direction.NORTH -> {
                if (shifted.booleanValue()) {
                    yield NORTH_SHAPE_SHIFTED;
                }
                yield NORTH_SHAPE;
            }
            case Direction.SOUTH -> {
                if (shifted.booleanValue()) {
                    yield SOUTH_SHAPE_SHIFTED;
                }
                yield SOUTH_SHAPE;
            }
            case Direction.WEST -> {
                if (shifted.booleanValue()) {
                    yield WEST_SHAPE_SHIFTED;
                }
                yield WEST_SHAPE;
            }
            case Direction.EAST -> {
                if (shifted.booleanValue()) {
                    yield EAST_SHAPE_SHIFTED;
                }
                yield EAST_SHAPE;
            }
            default -> Shapes.m_83040_();
        };
    }

    public static enum RoofTileType implements ShiftedTileType
    {
        NORMAL("roof_tiles", Map.ofEntries(Map.entry(0, Pair.of((Object)0, (Object)false)), Map.entry(1, Pair.of((Object)1, (Object)false)), Map.entry(2, Pair.of((Object)2, (Object)false)), Map.entry(3, Pair.of((Object)2, (Object)false)), Map.entry(4, Pair.of((Object)3, (Object)true)), Map.entry(5, Pair.of((Object)4, (Object)true)), Map.entry(6, Pair.of((Object)4, (Object)true)), Map.entry(7, Pair.of((Object)5, (Object)true)), Map.entry(8, Pair.of((Object)6, (Object)true)), Map.entry(9, Pair.of((Object)7, (Object)true)), Map.entry(10, Pair.of((Object)7, (Object)true)), Map.entry(11, Pair.of((Object)8, (Object)true)), Map.entry(12, Pair.of((Object)9, (Object)true)), Map.entry(13, Pair.of((Object)10, (Object)true)), Map.entry(14, Pair.of((Object)11, (Object)true)), Map.entry(15, Pair.of((Object)11, (Object)true))), 11),
        STAIRS("roof_tile_stairs", Map.ofEntries(Map.entry(0, Pair.of((Object)0, (Object)false)), Map.entry(1, Pair.of((Object)1, (Object)false)), Map.entry(2, Pair.of((Object)1, (Object)false)), Map.entry(3, Pair.of((Object)1, (Object)false)), Map.entry(4, Pair.of((Object)1, (Object)false)), Map.entry(5, Pair.of((Object)1, (Object)false)), Map.entry(6, Pair.of((Object)2, (Object)false)), Map.entry(7, Pair.of((Object)2, (Object)false)), Map.entry(8, Pair.of((Object)2, (Object)false)), Map.entry(9, Pair.of((Object)3, (Object)false)), Map.entry(10, Pair.of((Object)3, (Object)false)), Map.entry(11, Pair.of((Object)3, (Object)false)), Map.entry(12, Pair.of((Object)4, (Object)false)), Map.entry(13, Pair.of((Object)4, (Object)false)), Map.entry(14, Pair.of((Object)4, (Object)false)), Map.entry(15, Pair.of((Object)5, (Object)false))), 5),
        EDGE("roof_tile_edge", Map.ofEntries(Map.entry(0, Pair.of((Object)0, (Object)false)), Map.entry(1, Pair.of((Object)1, (Object)true)), Map.entry(2, Pair.of((Object)1, (Object)true)), Map.entry(3, Pair.of((Object)1, (Object)true)), Map.entry(4, Pair.of((Object)1, (Object)true)), Map.entry(5, Pair.of((Object)1, (Object)true)), Map.entry(6, Pair.of((Object)1, (Object)true)), Map.entry(7, Pair.of((Object)2, (Object)true)), Map.entry(8, Pair.of((Object)2, (Object)true)), Map.entry(9, Pair.of((Object)2, (Object)true)), Map.entry(10, Pair.of((Object)2, (Object)true)), Map.entry(11, Pair.of((Object)2, (Object)true)), Map.entry(12, Pair.of((Object)2, (Object)true)), Map.entry(13, Pair.of((Object)3, (Object)true)), Map.entry(14, Pair.of((Object)3, (Object)true)), Map.entry(15, Pair.of((Object)3, (Object)true))), 3);

        final String blockName;
        final Map<Integer, Pair<Integer, Boolean>> snowStages;
        final Integer maxSnowStages;

        private RoofTileType(String blockName, Map<Integer, Pair<Integer, Boolean>> snowStages, int maxSnowStages) {
            this.blockName = blockName;
            this.snowStages = snowStages;
            this.maxSnowStages = maxSnowStages;
        }

        public Map<Integer, Pair<Integer, Boolean>> getSnowStages() {
            return this.snowStages;
        }

        public Integer getMaxSnowStages() {
            return this.maxSnowStages;
        }

        public String toString() {
            return this.blockName;
        }
    }

    public static enum SnowSide implements StringRepresentable
    {
        LEFT("left"),
        RIGHT("right"),
        NONE("none"),
        BOTH("both");

        final String name;

        private SnowSide(String name) {
            this.name = name;
        }

        public static SnowSide add(SnowSide current, SnowSide toAdd) {
            if (toAdd == NONE) {
                return current;
            }
            if (current == LEFT || current == RIGHT) {
                if (current == toAdd) {
                    return current;
                }
                return BOTH;
            }
            if (current == NONE) {
                return toAdd;
            }
            return current;
        }

        public static SnowSide remove(SnowSide current, SnowSide toRemove) {
            if (toRemove == NONE) {
                return current;
            }
            if (current == LEFT || current == RIGHT) {
                if (toRemove == BOTH || current == toRemove) {
                    return NONE;
                }
                return current;
            }
            if (current == BOTH) {
                if (toRemove == BOTH) {
                    return NONE;
                }
                return toRemove == LEFT ? RIGHT : LEFT;
            }
            return current;
        }

        public String m_7912_() {
            return this.name;
        }
    }

    private static enum SlopeAngle {
        HIGHER,
        LOWER,
        LEVEL;

    }
}

